/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.dialog.IVWWebServiceParamPanel;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWParamExpressionCellEditor;
import filenet.vw.toolkit.design.property.tables.VWReceiveWSOperationParameterTableModel;
import filenet.vw.toolkit.utils.event.IVWTableActionListener;
import filenet.vw.toolkit.utils.event.VWTableActionEvent;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellItem;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultCellEditor;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

class VWReceiveWSOperationParameterPanel
extends JPanel
implements TableModelListener,
IVWTableActionListener,
ListSelectionListener,
IVWToolbarBorderActionListener {
    private VWToolbarBorder m_operationParamBorder = null;
    private VWTable m_operationParamTable = null;
    protected VWReceiveWSOperationParameterTableModel m_operationParamTableModel = null;
    protected VWAuthPropertyData m_authPropertyData = null;
    protected VWInstructionDefinition m_instructionDef = null;
    private boolean m_isFirstTime = true;
    private JDialog m_parentDialog = null;
    private Frame m_parentFrame = null;
    private IVWWebServiceParamPanel m_parentPanel = null;

    public VWReceiveWSOperationParameterPanel(JDialog parentDialog, IVWWebServiceParamPanel parentPanel, VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.m_parentDialog = parentDialog;
        this.m_parentPanel = parentPanel;
        this.init();
    }

    public VWReceiveWSOperationParameterPanel(Frame parentFrame, IVWWebServiceParamPanel parentPanel, VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.m_parentFrame = parentFrame;
        this.m_parentPanel = parentPanel;
        this.init();
    }

    public void reinitialize(VWReceiveInstruction instructionDef) {
        this.m_instructionDef = instructionDef;
        try {
            this.m_operationParamTableModel.reinitialize(instructionDef);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_isFirstTime) {
            this.m_isFirstTime = false;
            if (this.m_operationParamTable != null) {
                int width = this.m_operationParamTable.getViewPortWidth() / 2;
                int[] columnSizes = new int[]{width, width};
                this.m_operationParamTable.fitColumnsInTable(columnSizes);
            }
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_operationParamTable.getSelectedRow()) {
                    this.m_operationParamTable.clearSelection();
                }
                this.m_operationParamTable.setRowSelectionInterval(nRow, nRow);
            }
        }
        this.m_parentPanel.reinitializeCorrelationParamList();
    }

    public void tableActionPerformed(VWTableActionEvent event) {
        switch (event.getID()) {
            case 100: {
                if (this.m_operationParamTable == null) break;
                this.m_operationParamTable.stopEditing();
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            int nRowCount;
            this.m_operationParamBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_operationParamBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            int nRowIndex = this.m_operationParamTable.getSelectedRow();
            if (this.m_operationParamTableModel != null && nRowIndex != -1 && nRowIndex != (nRowCount = this.m_operationParamTableModel.getRowCount()) - 1) {
                this.m_operationParamBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_operationParamBorder.getClientPanel(), 1, Integer.MAX_VALUE));
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            if (event.getSource().equals(this.m_operationParamBorder)) {
                int nRowIndex = this.m_operationParamTable.getSelectedRow();
                if (nRowIndex == -1) {
                    return;
                }
                switch (event.getID()) {
                    case 0x10000000: {
                        this.m_operationParamTableModel.deleteItem(nRowIndex);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 23;
        gbCons.fill = 1;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.weightx = 1.0;
        gbCons.weighty = 1.0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_operationParamBorder = new VWToolbarBorder(VWResource.s_operationParameters, 0x10000000);
        this.m_operationParamBorder.addToolbarBorderActionNotifier(this);
        JPanel paramPanel = this.m_operationParamBorder.getClientPanel();
        paramPanel.setLayout(new BorderLayout());
        this.m_operationParamTableModel = this.m_parentDialog != null ? new VWReceiveWSOperationParameterTableModel(this.m_parentDialog, this.m_authPropertyData) : new VWReceiveWSOperationParameterTableModel(this.m_parentFrame, this.m_authPropertyData);
        this.m_operationParamTableModel.addTableModelListener(this);
        this.m_operationParamTable = new VWTable(this.m_operationParamTableModel);
        this.m_operationParamTable.getModel().addTableModelListener(this);
        this.m_operationParamTable.setDefaultRenderer(String.class, new VWToolTipTableCellRenderer());
        this.m_operationParamTable.setDefaultRenderer(VWToolTipTableCellItem.class, new VWToolTipTableCellRenderer());
        this.m_operationParamTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
        this.m_operationParamTable.getSelectionModel().setSelectionMode(0);
        this.m_operationParamTable.getSelectionModel().addListSelectionListener(this);
        this.initTableCells();
        paramPanel.add(new JScrollPane(this.m_operationParamTable));
        this.add((Component)this.m_operationParamBorder, gbCons);
    }

    protected void initTableCells() {
        this.initTableCell(1, new DefaultCellEditor(this.m_operationParamTableModel.getFieldTypeComboBox()));
        this.initTableCell(2, new VWParamExpressionCellEditor(this.m_authPropertyData));
    }

    protected void initTableCell(int nColumn, TableCellEditor cellEditor) {
        TableColumn tcElement = this.m_operationParamTable.getColumnModel().getColumn(nColumn);
        if (tcElement != null) {
            if (cellEditor != null) {
                tcElement.setCellEditor(cellEditor);
            }
            tcElement.setCellRenderer(new VWToolTipTableCellRenderer());
        }
    }
}

